//============================================================================
// CTF Snowy ScoreBoard
//============================================================================

class SnowCTFSB extends UnrealCTFScoreBoard;

#exec TEXTURE IMPORT NAME=Snow FILE=Textures\snowflake.bmp FLAGS=2

var float dx[30];
var float xp[30];
var float yp[30];
var float am[30];
var float stx[30];
var float sty[30];

var bool bInitialized;
var float MSCounter;
var color UnitColor;

event Tick(float delta)
	{
	MSCounter -= Delta;
	Super.Tick(Delta);
	}

function DrawHeader( canvas Canvas )
{
	local GameReplicationInfo GRI;
	local float XL, YL;
	local font CanvasFont;
	local int i;
	local byte Style;
	local color BaseColor;

	if (!bInitialized)
	{
		MSCounter = 0;
		bInitialized = true;
		for (i=0;i<30;i++)
		{
			dx[i] = 0;
			xp[i] = frand() * Canvas.ClipX;
			yp[i] = frand() * Canvas.ClipY;
			am[i] = frand() * 20;
			stx[i] = 0.02 + frand() / 10;
			sty[i] = 0.7 +  frand();
		}
	}

	Style = Canvas.Style;
/*
	Canvas.Style = ERenderStyle.STY_Translucent;

	Canvas.Font = MyFonts.GetHugeFont(Canvas.ClipX);
	Canvas.DrawColor = (16 * 5 + 15) * UnitColor;
	Canvas.SetPos(2, 2);
	Canvas.DrawIcon(texture 'Santa',1);
	Canvas.SetPos(Canvas.ClipX-90,2);
	Canvas.DrawIcon(texture 'Santa',1);
	Canvas.SetPos(( Canvas.ClipX / 2) - 192, 2);
	Canvas.DrawIcon(texture 'XmasBanner',1);
*/
	Super.DrawHeader(canvas);

	Canvas.Style = Style;		//ERenderStyle.STY_Normal;

	xl = Canvas.CurX;
	yl = Canvas.CurY;

	for (i=0;i<30;i++)
	{
		if (MSCounter<=0)
		{

			yp[i] += sty[i];
			if (yp[i] > Canvas.ClipY)
			{
				xp[i] = Rand(Canvas.clipX);
				yp[i] = -23;
				stx[i] = 0.02 + frand() /10;
				sty[i] = 0.7 +  frand();
			}

			dx[i]+= stx[i];
		}

		Canvas.SetPos(xp[i]+am[i]*sin(dx[i]),yp[i]);
		Canvas.Style = 3;
		Canvas.DrawIcon(texture 'Snow',1);
		Canvas.Style = 1;
	}

	if (MSCounter<=0)
		MSCounter = 0.025;

	Canvas.SetPos(xl,yl);

}


/*

function DrawVictoryConditions(Canvas Canvas)
{
	local TournamentGameReplicationInfo TGRI;
	local float XL, YL;
	local string s;
	local font f;

	TGRI = TournamentGameReplicationInfo(PlayerPawn(Owner).GameReplicationInfo);
	if ( TGRI == None )
		return;

	f = Canvas.Font;

	Canvas.Font = MyFonts.GetSmallFont(Canvas.ClipX);
	S = FragGoal@TGRI.GoalTeamScore;
	Canvas.StrLen(s, XL, YL);
	Canvas.SetPos(0, 64);
	Canvas.DrawText(s);
	Canvas.Font = f;
}

*/